

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
labels = [
    "Portfolio_A",
    "Portfolio_B",
    "Portfolio_C",
    "Portfolio_D",
    "Portfolio_E",
    "Portfolio_F",
    "Portfolio_G",
    "Portfolio_H",
]
baseline_scores = [5.3, 6.7, 4.5, 8.0, 3.2, 7.1, 4.8, 9.0]
improved_scores = [6.2, 7.5, 5.8, 9.3, 4.0, 8.0, 5.5, 10.2]

line_y_1 = 5
line_y_2 = 7.5
line_x_1 = 2.5
line_x_2 = 5.5

# Labels and Plot Types
label_Baseline = "2021"
label_Improved = "2022"
legend_title = "Annual Return"

# Axes Limits and Labels
ylabel_value = "Annual Return (%)"
title_value = "Annual Return of Investment Portfolios in 2021 and 2022"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
x = np.arange(len(labels))  # the label locations
width = 0.7  # the width of the bars
ylim_values = [0, 12]
xlim_values = [-0.6, 8]

# Plotting
fig, ax = plt.subplots(figsize=(12, 6))  # Adjust the size accordingly

rects2 = ax.bar(x, improved_scores, width, label=label_Improved, color="#9bbb59")
rects1 = ax.bar(x, baseline_scores, width, label=label_Baseline, color="#4f81bd")
# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)
ax.set_xticks(x)
ax.set_xticklabels(labels, rotation=45, ha="right")
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Adding the values on top of the bars
for rect in rects1:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )
for rect in rects2:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

# Reference lines
ax.axhline(y=line_y_1, color="red", linestyle="--")
ax.axhline(y=line_y_2, color="gray", linestyle="--")
ax.axvline(x=line_x_1, color="gray", linestyle="--")
ax.axvline(x=line_x_2, color="gray", linestyle="--")

# Adding gridlines
ax.grid(True, which='both', linestyle='--', linewidth=0.5, color='grey', alpha=0.7)

# Hide the ticks (optional based on preference; here, we keep ticks visible for clarity)
# ax.tick_params(axis="both", which="both", length=0)

# Hide the right and top spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.legend(title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_90.pdf", bbox_inches="tight")

