
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Import numpy in this section

np.random.seed(1)

# Data
labels = [
    "Wheat",
    "Corn",
    "Rice",
    "Barley",
    "Soybean",
    "Oats",
    "Cotton",
    "Sugarcane",
    "Millet",
    "Rye",
    "Sorghum",
    "Potato",
    "Tomato",
    "Maize",
]
machine_harvested = [0, 0, 0, 0, 0, 0, 0, 12.5, 3.6, 3.5, 5.7, 8.5, 6.5, 7.6]
hand_harvested = [
    2.2,
    3.1,
    4.0,
    2.5,
    3.0,
    2.2,
    2.9,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
]

line_y_1 = 4
line_y_2 = 8
line_x_1 = 4.5
line_x_2 = 10.5

# Labels and Plot Types
label_Machine_Harvested = "Machine-Harvested"
label_Hand_Harvested = "Hand-Harvested"
legend_title = "Harvest Method"

# Axes Limits and Labels
ylabel_value = "Average Yield (tons/hectare)"
title_value = "Average Crop Yields by Harvest Method"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
x = np.arange(len(labels))  # the label locations
width = 0.7  # the width of the bars
ylim_values = [0, 14]
xlim_values = [-0.6, 14]

# Color Scheme
color_machine_harvested = "#2E8B57"  # SeaGreen
color_hand_harvested = "#FF6347"     # Tomato

# Plotting
fig, ax = plt.subplots(
    figsize=(12, 6)
)  # Adjust the size to match the original image's dimensions
rects1 = ax.bar(x, machine_harvested, width, label=label_Machine_Harvested, color=color_machine_harvested)
rects2 = ax.bar(x, hand_harvested, width, label=label_Hand_Harvested, color=color_hand_harvested)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)
ax.set_xticks(x)
ax.set_xticklabels(labels, rotation=45, ha="center")
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Adding the values on top of the bars
for rect in rects1:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )
for rect in rects2:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

# Reference lines
ax.axhline(y=line_y_1, color="red", linestyle="--")
ax.axhline(y=line_y_2, color="blue", linestyle="--")
ax.axvline(x=line_x_1, color="gray", linestyle="--")
ax.axvline(x=line_x_2, color="gray", linestyle="--")

# Hide the ticks
ax.tick_params(axis="both", which="both", length=0)

# Hide the right and top spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.legend(title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_92.pdf", bbox_inches="tight")
