
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar chart
months = ["June", "July", "August"]
wheat_yield = [20, 25, 30]
corn_yield = [22, 27, 35]
rice_yield = [23, 28, 36]

labels = ["Wheat", "Corn", "Rice"]
ylabel = "Avg. Yield (tons)"

y_index = [0, 10, 20, 30, 40]
ylim = [0, 40]
y_label_ticks = ["0", "10", "20", "30", "40"]

# Annotations for bar heights
annotation_offsets = 1  # Offset for text annotations above bars

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 4))

# Create the bar chart
bar_width = 0.25
index = range(len(months))

colors = ["#6baed6", "#9ecae1", "#c6dbef"]  # Shades of blue for rainfall

plt.bar(
    [i - bar_width for i in index],
    wheat_yield,
    width=bar_width,
    color=colors[0],
    edgecolor="black",
    label=labels[0],
)
plt.bar(
    index, corn_yield, width=bar_width, color=colors[1], edgecolor="black", label=labels[1]
)
plt.bar(
    [i + bar_width for i in index],
    rice_yield,
    width=bar_width,
    color=colors[2],
    edgecolor="black",
    label=labels[2],
)

# Add the text labels on top of the bars
for i in index:
    plt.text(
        i - bar_width,
        wheat_yield[i] + annotation_offsets,
        f"{wheat_yield[i]}",
        ha="center",
    )
    plt.text(i, corn_yield[i] + annotation_offsets, f"{corn_yield[i]}", ha="center")
    plt.text(i + bar_width, rice_yield[i] + annotation_offsets, f"{rice_yield[i]}", ha="center")

# Set the x-axis labels, y-axis label, and chart title
plt.xticks(index, months)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.yticks(y_index, y_label_ticks)

# Add a legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Hide the right and top spines
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_93.pdf", bbox_inches="tight")
