
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Financial metrics labels
financial_metrics = [
    "Revenue Growth",
    "Net Profit Margin",
    "Return on Equity",
    "Earnings Per Share",
    "Operating Margin",
    "Debt to Equity Ratio",
    "Current Ratio",
    "Quick Ratio",
    "Interest Coverage",
    "Asset Turnover",
]

# Approximate percentage values for these financial metrics
percentages = [
    10.5,
    7.8,
    14.2,
    6.4,
    12.0,
    4.5,
    3.8,
    2.7,
    5.6,
    9.3,
]

xlabel = "Percentage (%)"
ylabel = "Financial Metrics"
title = "Key Financial Metrics Analysis"
xticks = list(range(0, 16))
xlim = [0, 15]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
colors = plt.cm.plasma(np.linspace(0, 1, len(financial_metrics)))  # Use a nice colormap for the bars
plt.barh(financial_metrics, percentages, color=colors, edgecolor="gray")

# Set x-axis limits
plt.xlim(xlim)

# Set x-axis ticks
plt.xticks(xticks)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add grid for better readability
plt.grid(axis='x', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_97.pdf", bbox_inches="tight")
