

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(12)
# Sample data for tourism domain
tourist_arrivals_data = [np.random.normal(1600, 300, 100), np.random.normal(800, 350, 100)]
hotel_occupancy_rate_data = [np.random.normal(55, 10, 100), np.random.normal(30, 10, 100)]

# Titles and Labels
title_1 = "Tourist Arrivals"
title_2 = "Hotel Occupancy Rate"
xticklabels = ["City A", "City B"]
xlabel = "Destination City"
ylabel_arrivals = "Number of Tourists"
ylabel_occupancy = "Occupancy Rate (%)"
legendlabels = ["City A", "City B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size for better readability
plt.figure(figsize=(10, 8))

# Create subplots
fig, axs = plt.subplots(2, 2)

# Plot the boxplots
bp1 = axs[0, 0].boxplot(
    tourist_arrivals_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp2 = axs[0, 1].boxplot(
    hotel_occupancy_rate_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp3 = axs[1, 0].boxplot(
    tourist_arrivals_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp4 = axs[1, 1].boxplot(
    hotel_occupancy_rate_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)

# New color scheme
colors = ["#3cb371", "#4682b4"]

# Set the colors of the boxes
for bp in [bp1, bp2, bp3, bp4]:
    for i in range(2):
        bp["boxes"][i].set_facecolor(colors[i])

# Set titles and labels
axs[0, 0].set_title(title_1)
axs[0, 1].set_title(title_2)
axs[1, 0].set_title(title_1)
axs[1, 1].set_title(title_2)

# Set x-axis labels
for ax in axs.flat:
    ax.set_xticklabels(xticklabels)
    ax.grid(True)

# Set y-axis labels for clarity
axs[0, 0].set_ylabel(ylabel_arrivals)
axs[0, 1].set_ylabel(ylabel_occupancy)
axs[1, 0].set_ylabel(ylabel_arrivals)
axs[1, 1].set_ylabel(ylabel_occupancy)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_31.pdf", bbox_inches="tight")

