

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Random data to simulate the boxplot values for different regions
data_North_America = np.random.normal(150, 20, 100)
data_Europe = np.random.normal(120, 10, 100)
data_Asia = np.random.normal(160, 22, 100)
data_South_America = np.random.normal(140, 15, 100)

data = [data_North_America, data_Europe, data_Asia, data_South_America]

# Labels and Plot Types
legend_labels = ["North America", "Europe", "Asia", "South America"]

# Axes Limits and Labels
xticklabels = ["North America", "Europe", "Asia", "South America"]
ylabel_value = "Sales Performance (in $1000)"
ylim_values = [90, 220]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))
bp = ax.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing the boxplot colors
colors = ["#1f77b4", "#2ca02c", "#d62728", "#9467bd"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Customizing the boxplot median lines
for median in bp["medians"]:
    median.set(color="black", linewidth=1.5)

legend_patches = [
    mpatches.Patch(color=color, label=label)
    for color, label in zip(colors, legend_labels)
]
ax.legend(handles=legend_patches, loc="upper right")

# Setting the x-axis labels
ax.set_xticklabels(xticklabels)

# Setting the y-axis label
ax.set_ylabel(ylabel_value)

# Setting the y-axis limits
ax.set_ylim(ylim_values)

# Adding grid lines
ax.yaxis.grid(True, which="major", color="grey", alpha=0.5)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_32.pdf", bbox_inches="tight")

