# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for the boxplots
data_user_ratings = [
    np.random.normal(7.5, 1, 100),  # Genre 1 (e.g., Action)
    np.random.normal(8.0, 1, 100),  # Genre 2 (e.g., Comedy)
    np.random.normal(6.5, 1, 100),  # Genre 3 (e.g., Drama)
]
data_critic_ratings = [
    np.random.normal(6.0, 1.2, 100),  # Genre 1 (e.g., Action)
    np.random.normal(7.5, 1.2, 100),  # Genre 2 (e.g., Comedy)
    np.random.normal(6.8, 1.2, 100),  # Genre 3 (e.g., Drama)
]

titles = ["User Ratings Comparison", "Critic Ratings Comparison"]
ylabels = ["User Ratings", "Critic Ratings"]
xticklabels = ["Action", "Comedy", "Drama"]
yticks_user_ratings = np.arange(4, 10, 1)
yticks_critic_ratings = np.arange(2, 10, 1)
title = "Comparison of Ratings Across Different Movie Genres"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
fig, axs = plt.subplots(1, 2, figsize=(12, 6))

# Create the boxplots
bp1 = axs[0].boxplot(
    data_user_ratings,
    medianprops=dict(color="green"),
    boxprops=dict(color="blue"),
    whiskerprops=dict(color="blue"),
    capprops=dict(color="blue"),
    flierprops=dict(marker="o", color="red", alpha=0.5),
)
bp2 = axs[1].boxplot(
    data_critic_ratings,
    medianprops=dict(color="green"),
    boxprops=dict(color="blue"),
    whiskerprops=dict(color="blue"),
    capprops=dict(color="blue"),
    flierprops=dict(marker="o", color="red", alpha=0.5),
)

# Set titles for subplots
axs[0].set_title(titles[0])
axs[1].set_title(titles[1])

# Set y-axis labels
axs[0].set_ylabel(ylabels[0])
axs[1].set_ylabel(ylabels[1])

# Set y-axis ticks
axs[0].set_yticks(yticks_user_ratings)
axs[1].set_yticks(yticks_critic_ratings)

# Set x-axis labels
axs[0].set_xticklabels(xticklabels, rotation=45)
axs[1].set_xticklabels(xticklabels, rotation=45)

# Add grids
axs[0].grid(True, linestyle="--", alpha=0.7)
axs[1].grid(True, linestyle="--", alpha=0.7)

# Adjust layout to improve spacing
plt.subplots_adjust(left=0.1, right=0.9, top=0.9, bottom=0.15, wspace=0.4)

# Add a super title
plt.suptitle(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("box_51.pdf", bbox_inches="tight")
