

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Sample data for the boxplots
data = {
    "Memory Exercises": np.random.uniform(15, 45, 20),
    "Problem-Solving Tasks": np.random.uniform(30, 90, 20),
    "Creative Tasks": np.random.uniform(45, 120, 20),
    "Attention Training": np.random.uniform(5, 30, 20),
}
xlabel = "Time Spent (minutes per week)"
title = "Weekly Time Spent on Cognitive Activities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(10, 6))

# Create the boxplots with specific colors
boxprops = dict(linestyle="--", linewidth=1.5, color="navy")
flierprops = dict(marker="o", color="orange", markerfacecolor="orange", markersize=6)
medianprops = dict(linestyle="-", linewidth=2.5, color="darkred")

# Boxplot with vertical orientation
bp = ax.boxplot(
    data.values(),
    vert=False,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

colors = ["#a6cee3", "#1f78b4", "#b2df8a", "#33a02c"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
    # Scatter plot for data points
    for j, key in enumerate(data.keys()):
        x = data[key]
        y = np.random.normal(j + 1, 0.02, size=len(x))
        plt.plot(x, y, "k.", alpha=0.6, color="#4e8a84")

# Set the x-axis labels with data keys
ax.set_yticklabels(data.keys(), ha="right")

# Set the y-axis label
ax.set_xlabel(xlabel)
ax.xaxis.grid(False)
ax.xaxis.grid(True)

# Set the title of the plot
ax.set_title(title, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_53.pdf", bbox_inches="tight")

