

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Sample data for the boxplots in the weather domain
data = {
    "Temperature (°C)": np.random.uniform(15, 35, 20),
    "Humidity (%)": np.random.uniform(50, 90, 20),
    "Wind Speed (km/h)": np.random.uniform(5, 25, 20),
    "Precipitation (mm)": np.random.uniform(0, 50, 20),
}
xlabel = "Measurement Values"
ylabel = "Weather Metrics"
title = "Weather Data Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(9, 5))

# Create the boxplots with specific colors
boxprops = dict(linestyle="-", linewidth=2, color="#4d4d4d")
flierprops = dict(marker="o", color="orange", markerfacecolor="orange", markersize=5)
medianprops = dict(linestyle="-", linewidth=2, color="blue")

# Boxplot with vertical orientation
bp = ax.boxplot(
    data.values(),
    vert=False,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

colors = ["#c6dbef", "#9ecae1", "#6baed6", "#3182bd"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
    # Scatter plot for data points
    for j, key in enumerate(data.keys()):
        x = data[key]
        y = np.random.normal(j + 1, 0.02, size=len(x))
        plt.plot(x, y, "k.", alpha=0.4, color="#4d4d4d")

# Set the x-axis and y-axis labels with data keys
ax.set_yticklabels(data.keys(), ha="right")
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.xaxis.grid(False)
ax.xaxis.grid(True)

# Set the title of the plot
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_54.pdf", bbox_inches="tight")
