
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Sample data for art and design domain
popularity_scores = [
    np.random.normal(70, 10, 100),
    np.random.normal(65, 12, 100),
    np.random.normal(75, 15, 100),
]
daily_visits = [
    np.random.normal(120, 20, 100),
    np.random.normal(150, 25, 100),
    np.random.normal(100, 30, 100),
]

# Labels and titles
titles = ["Art Piece Popularity Scores", "Daily Visits to Art Exhibitions"]
xticklabels = ["Modern Art", "Renaissance Art", "Contemporary Art"]
ylabels = ["Popularity Score", "Daily Visits (Thousands)"]
yticks = [np.arange(40, 110, 10), np.arange(50, 250, 50)]
ylims = [[40, 110], [50, 250]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots with specified figure size
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
medianprops = dict(linestyle="-", linewidth=1, color="black")
# Left subplot - Art Piece Popularity Scores
bplot1 = ax1.boxplot(
    popularity_scores,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=4),
)
ax1.set_title(titles[0])
ax1.set_xticklabels(xticklabels)
ax1.set_ylabel(ylabels[0])
ax1.set_yticks(yticks[0])
ax1.set_ylim(ylims[0])
ax1.set_facecolor("#f7f7f7")
ax1.yaxis.grid(True, color="gray", linestyle='--', linewidth=0.5)

# Add median value annotations
for i, line in enumerate(bplot1["medians"]):
    x, y = line.get_xydata()[1]
    ax1.text(x-0.3, y+0.5, f"{y:.2f}", horizontalalignment="center", color="black", fontsize=8)

# Right subplot - Daily Visits to Art Exhibitions
bplot2 = ax2.boxplot(
    daily_visits,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=4),
)
ax2.set_title(titles[1])
ax2.set_xticklabels(xticklabels)
ax2.set_ylabel(ylabels[1])
ax2.set_yticks(yticks[1])
ax2.set_ylim(ylims[1])
ax2.set_facecolor("#f7f7f7")
ax2.yaxis.grid(True, color="gray", linestyle='--', linewidth=0.5)

# Add median value annotations
for i, line in enumerate(bplot2["medians"]):
    x, y = line.get_xydata()[1]
    ax2.text(x-0.3, y+2, f"{y:.2f}", horizontalalignment="center", color="black", fontsize=8)

# Set colors for boxplots
colors = ["#4CAF50", "#FF5722", "#2196F3"]
for bplot in (bplot1, bplot2):
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_65.pdf", bbox_inches="tight")
