
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for demonstration purposes in the psychology domain
stress_levels = [
    np.random.normal(30, 5, 100),
    np.random.normal(40, 7, 100),
    np.random.normal(20, 6, 100),
]
happiness_levels = [
    np.random.normal(60, 10, 100),
    np.random.normal(70, 8, 100),
    np.random.normal(55, 9, 100),
]

titles = ["Stress Levels", "Happiness Levels"]
xticklabels = ["Students", "Working Professionals", "Retirees"]
ylabels = ["Stress Level (units)", "Happiness Level (units)"]
yticks = [np.arange(0, 61, 10), np.arange(20, 101, 20)]
ylims = [[0, 60], [20, 100]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots with specified figure size
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
medianprops = dict(linestyle="-", linewidth=1.5, color="black")

# Left subplot - Stress Levels
bplot1 = ax1.boxplot(
    stress_levels,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=6),
)
ax1.set_title(titles[0])
ax1.set_xticklabels(xticklabels)
ax1.set_ylabel(ylabels[0])
ax1.set_yticks(yticks[0])
ax1.set_ylim(ylims[0])
ax1.set_facecolor("#f2f2f2")
ax1.yaxis.grid(True, color="#d9d9d9")

# Add median value annotations
for i, line in enumerate(bplot1["medians"]):
    x, y = line.get_xydata()[1]
    ax1.text(x-0.3, y+1, f"{y:.1f}", horizontalalignment="center", color="black", weight='bold')

# Right subplot - Happiness Levels
bplot2 = ax2.boxplot(
    happiness_levels,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="black", markerfacecolor="black", markersize=6),
)
ax2.set_title(titles[1])
ax2.set_xticklabels(xticklabels)
ax2.set_ylabel(ylabels[1])
ax2.set_yticks(yticks[1])
ax2.set_ylim(ylims[1])
ax2.set_facecolor("#f2f2f2")
ax2.yaxis.grid(True, color="#d9d9d9")

# Add median value annotations
for i, line in enumerate(bplot2["medians"]):
    x, y = line.get_xydata()[1]
    ax2.text(x-0.3, y+1, f"{y:.1f}", horizontalalignment="center", color="black", weight='bold')

# Set colors for boxplots
colors = ["#66c2a5", "#fc8d62", "#8da0cb"]
for bplot in (bplot1, bplot2):
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_67.pdf", bbox_inches="tight")
