
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for exam scores
center = np.random.randint(60, 90, 5)
data = [np.random.normal(center[std - 1], std * 2.5, 100) for std in range(1, 6)]
xticklabels = ["Failing", "Below Average", "Average", "Above Average", "Excellent"]
ylabel = "Exam Scores"
xhline = 50
title = "Distribution of Exam Scores by Achievement Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified dimensions
fig, ax = plt.subplots(figsize=(10, 6))

# Define custom properties for the boxplot
medianprops = dict(linestyle="-", linewidth=1.5, color="blue")
box = ax.boxplot(data, patch_artist=True, medianprops=medianprops)

# Define a custom color palette
colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072", "#80b1d3"]
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

# Add threshold line
ax.axhline(xhline, color="r", linestyle="--", label="Pass Mark")

# Set x-axis labels
ax.set_xticklabels(xticklabels, rotation=45, ha="right")

# Set y-axis label and title
ax.set_ylabel(ylabel)
ax.set_title(title, fontsize=14)

# Add legend for the threshold line
ax.legend(loc="upper left", frameon=False)

# Additional stylistic adjustments
plt.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.savefig("box_68.pdf", bbox_inches="tight")
