

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data to represent energy consumption in kWh
data = {
    "Energy Consumption": np.random.rand(6, 6) * 2000,  # Energy consumption between 0 and 2000 kWh
}

labels = [
    "Residential",
    "Commercial",
    "Industrial",
    "Transportation",
    "Agricultural",
    "Public Services",
]
xlim = [0, 2000]

# Text label parameters
title = "Energy Consumption of Different Sectors"
xlabel = "Energy Consumption (kWh)"
ylabel = ""

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), constrained_layout=True)
colors = ["#a1c9f4", "#ffb482", "#8de5a1", "#ff9f9b", "#d0bbff", "#fffea3"]
bplot = ax.boxplot(
    data["Energy Consumption"],
    vert=False,
    patch_artist=True,
    showcaps=False,
    showfliers=False,
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    medianprops={"color": "black"},
    boxprops=dict(linestyle="-", linewidth=1),
)
for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.7)  # Adding transparency for better visualization
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_yticklabels(labels, fontsize=12)
ax.set_xlim(xlim)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.xaxis.grid(True, alpha=0.5)
ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_71.pdf", bbox_inches="tight")

