

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated student grades (out of 100) for different exams over a semester (10 exams)
data = [np.random.normal(75, 10, 100) for _ in range(10)]
xticklabels = [f"Exam {i+1}" for i in range(10)]
ylabel = "Grades"
xlabel = "Exam"
title = "Student Grades Across Exams"
legend_label = "Minimum Grade"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(10, 6))

boxprops = dict(linestyle="-", linewidth=2, color="#4CAF50")
medianprops = dict(linestyle="--", linewidth=2, color="#FF9800")
meanprops = dict(marker="D", markerfacecolor="red", markeredgecolor="black")

bp = ax.boxplot(
    data,
    patch_artist=True,
    showmeans=True,
    meanprops=meanprops,
    showfliers=False,
    boxprops=boxprops,
    medianprops=medianprops,
)

# Setting face color for each box
for patch in bp["boxes"]:
    patch.set(facecolor="#C8E6C9")

# Add minimum value markers
for i, line in enumerate(bp["whiskers"][::2]):
    min_val = line.get_ydata()[1]  # Get the y value of the minimum whisker
    ax.plot(i + 1, min_val, marker="o", color="blue", label=legend_label if i == 0 else "")

# Set the x-axis labels
ax.set_xticklabels(xticklabels, rotation=45)

# Set axis labels and title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)

# Add grid for better readability
ax.yaxis.grid(True)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_75.pdf", bbox_inches="tight")

