

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Simulate attendance data: daily attendance for 10 different religious events over 100 days
data = [
    np.random.normal(150, 20, 100),
    np.random.normal(80, 15, 100),
    np.random.normal(120, 25, 100),
    np.random.normal(100, 18, 100),
    np.random.normal(200, 30, 100),
    np.random.normal(50, 10, 100),
    np.random.normal(170, 22, 100),
    np.random.normal(90, 12, 100),
    np.random.normal(140, 20, 100),
    np.random.normal(110, 14, 100),
]
xticklabels = [f"Event {i+1}" for i in range(10)]
ylabel = "Daily Attendance"
title = "Religious Event Attendance Over 100 Days"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(10, 6))

boxprops = dict(linestyle="-", linewidth=1.5, color="green")
medianprops = dict(linestyle="-", linewidth=2, color="darkgreen")
meanprops = dict(marker="D", markeredgecolor="black", markerfacecolor="yellow")
whiskerprops = dict(linestyle="--", linewidth=1.5, color="darkgrey")
capprops = dict(linewidth=1.5, color="darkgrey")

bp = ax.boxplot(
    data,
    patch_artist=True,
    showmeans=True,
    meanprops=meanprops,
    showfliers=False,
    boxprops=boxprops,
    medianprops=medianprops,
    whiskerprops=whiskerprops,
    capprops=capprops,
)

for patch in bp["boxes"]:
    patch.set(facecolor="lightgreen")

# Set the x-axis labels
ax.set_xticklabels(xticklabels, rotation=45, ha='right')

# Set the y-axis label
ax.set_ylabel(ylabel)

# Set the title
ax.set_title(title)

# Add markers for minimum values
for i, line in enumerate(bp["whiskers"][::2]):
    min_val = line.get_ydata()[1]  # Get the y value of the minimum whisker
    ax.plot(i + 1, min_val, marker="*", color="red", markersize=10)  # Add marker

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_76.pdf", bbox_inches="tight")

