
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for the weather domain (Monthly average temperatures in Celsius)
data_region1 = np.random.normal(15, 5, 12)
data_region2 = np.random.normal(10, 7, 12)
data_region3 = np.random.normal(20, 6, 12)

data = [data_region1, data_region2, data_region3]
ylabel = "Monthly Average Temperature (°C)"
xticklabels = ["Winter", "Spring", "Summer", "Fall"]
xticks = [1, 2, 3, 4]
ylim = [-10, 40]
categories = ["Region 1", "Region 2", "Region 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to appropriately display data
plt.figure(figsize=(12, 6))

# Define colors for each boxplot
colors = ["#ff9999", "#66b3ff", "#99ff99"]

# Create subplots for each category
for i, category in enumerate(categories, 1):
    plt.subplot(1, 3, i)
    bplot = plt.boxplot(
        data,
        patch_artist=True,
        widths=0.7,
        medianprops=dict(color="black"),
        whiskerprops=dict(color="black"),
        capprops=dict(color="black"),
    )

    # Set colors for each box
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

    # Scatter plot for data points
    for j in range(1, 4):
        y = data[j - 1]
        x = np.random.normal(j, 0.04, size=len(y))
        plt.plot(x, y, "k.", alpha=0.6)

    plt.title(category)
    plt.xticks(xticks, xticklabels)
    plt.ylim(ylim)
    if i == 1:
        plt.ylabel(ylabel)
    plt.gca().xaxis.grid(True)
    plt.gca().spines["top"].set_visible(False)
    plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_80.pdf", bbox_inches="tight")
