# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for population statistics
population_growth_rate = np.random.normal(1.2, 0.15, 20)
birth_rate = np.random.normal(2.5, 0.3, 20)
death_rate = np.random.normal(0.9, 0.2, 20)

data = [population_growth_rate, birth_rate, death_rate]
ylabel = "Rates per 1000 People"
xticklabels = ["Population\nGrowth Rate", "Birth Rate", "Death Rate"]
xticks = [1, 2, 3]
ylim = [0, 3]
categories = ["Urban Areas", "Suburban Areas", "Rural Areas"]

# Labels for visual context
suptitle = "Population Statistics"
title_labels = ["Population Growth Rate", "Birth Rate", "Death Rate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 6))
# Define colors for each boxplot
colors = ["#ADD8E6", "#FFD700", "#FFFFFF"]

# Create subplots for each category
for i, category in enumerate(categories, 1):
    plt.subplot(1, 3, i)
    bplot = plt.boxplot(
        data,
        patch_artist=True,
        widths=0.7,
        medianprops=dict(color="darkblue"),
        whiskerprops=dict(color="darkblue"),
        capprops=dict(color="darkblue"),
    )

    # Set colors for each box
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

    # Scatter plot for data points
    markers = ["o", "s", "^"]
    for j in range(1, 4):
        y = data[j - 1]
        x = np.random.normal(j, 0.04, size=len(y))
        plt.plot(
            x, y, marker=markers[j - 1], linestyle="None", alpha=0.7, color="black"
        )

    plt.title(category)
    plt.xticks(xticks, xticklabels)
    plt.ylim(ylim)
    if i == 1:
        plt.ylabel(ylabel)
    plt.gca().xaxis.grid(True)
    plt.gca().spines["top"].set_visible(False)
    plt.gca().spines["right"].set_visible(False)

# Add supertitle for the entire figure
plt.suptitle(suptitle, fontsize=16, fontweight="bold")
plt.tight_layout(rect=[0, 0, 1, 0.95])  # adjust tight layout to fit supertitle

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("box_82.pdf", bbox_inches="tight")
