# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Placeholder data for the boxplots in the environmental science domain
data1 = [
    np.random.normal(50, 10, 100),
    np.random.normal(55, 12, 100),
]  # Air Quality Index (AQI)
data2 = [
    np.random.normal(400, 30, 100),
    np.random.normal(420, 35, 100),
]  # CO2 Levels (ppm)
data3 = [np.random.normal(25, 5, 100), np.random.normal(27, 6, 100)]  # Temperature (°C)
data4 = [np.random.normal(60, 10, 100), np.random.normal(65, 12, 100)]  # Humidity (%)
data5 = [
    np.random.normal(100, 20, 100),
    np.random.normal(110, 25, 100),
]  # Precipitation (mm)

# Titles and labels to match the environmental science data
titles = [
    "Air Quality Index",
    "CO2 Levels",
    "Temperature",
    "Humidity",
    "Precipitation",
]
xticklabels = ["Region A", "Region B"]
xticks = [1, 2]
xlabel = "Regions"
ylabels = (
    "AQI",
    "CO2 (ppm)",
    "Temperature (°C)",
    "Humidity (%)",
    "Precipitation (mm)",
)
suptitle = "Environmental Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom dimensions to match the original image
fig, axs = plt.subplots(1, 5, figsize=(15, 7))  # Adjusted dimensions

# Define colors for the boxplots
colors = ["#2ca02c", "#8c564b"]  # Green and Brown colors for environmental science

# Plot the boxplots with the specified colors and outlier shapes
for i, data in enumerate([data1, data2, data3, data4, data5]):
    bplot = axs[i].boxplot(
        data,
        patch_artist=True,
        notch=False,
        widths=0.7,
        medianprops=dict(color="black"),
        flierprops=dict(
            marker="o", color="black", markerfacecolor="black", markersize=5
        ),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# Set the titles for each subplot
for ax, title in zip(axs, titles):
    ax.set_title(title, fontsize=12, fontweight="bold")

# Set the x-axis labels with proper spacing
for ax in axs:
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels, fontsize=10)
    ax.set_xlabel(xlabel, fontsize=10)

# Set the y-axis labels
for ax, ylabel in zip(axs, ylabels):
    ax.set_ylabel(ylabel, fontsize=10)
    ax.grid(True)  # Add grid for better readability

# Set a common super title
plt.suptitle(suptitle, fontsize=16, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjust rect to make space for suptitle
plt.savefig("box_85.pdf", bbox_inches="tight")
