

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Viewership Ratings for different years
data = [
    np.random.normal(50, 10, 100),  # Year 2016
    np.random.normal(55, 12, 100),  # Year 2017
    np.random.normal(60, 15, 100),  # Year 2018
    np.random.normal(65, 8, 100),   # Year 2019
    np.random.normal(70, 10, 100),  # Year 2020
]

labels = ["2016", "2017", "2018", "2019", "2020"]

# Axes Limits and Labels
ylim_values = [0, 100]
xlabel_value = "Year"
ylabel_value = "Viewership Rating (%)"
title_value = "Streaming Platform Viewership Ratings Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusting figure size for better aspect ratio
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(facecolor="#1f77b4", color="#1f77b4"),
    medianprops=dict(color="#ff7f0e", linewidth=2),
    whiskerprops=dict(color="#2ca02c", linestyle="--", linewidth=1.5),
    capprops=dict(color="#d62728", linewidth=1.5),
    showfliers=False 
)

# Customize colors
for patch in bp['boxes']:
    patch.set(facecolor='#17becf')  # Different shade for boxes

ax.set_ylim(ylim_values)
# Set labels
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)  # Set title

# Set grid
ax.grid(True, linestyle='--', color='gray', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_90.pdf", bbox_inches="tight")

