

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample survey rating data for the boxplots
data = {
    "Existentialism": np.random.normal(6, 1.5, 100),
    "Stoicism": np.random.normal(7, 1.2, 100),
    "Nihilism": np.random.normal(4, 2, 100),
    "Absurdism": np.random.normal(5, 1.8, 100),
}
ylabel = "Survey Ratings (1-10)"
title = "Distribution of Survey Ratings on Philosophical Schools"
xlabel = "Philosophical Schools of Thought"
annotation_text = "Median"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(10, 6))

# Create the boxplots with specific colors
boxprops = dict(linestyle="--", linewidth=1.5, color="teal")
flierprops = dict(marker="o", color="orange", markerfacecolor="orange", markersize=6)
medianprops = dict(linestyle="-", linewidth=2, color="darkred")
whiskerprops = dict(linestyle=":", color="black")

# Boxplot with vertical orientation
bp = ax.boxplot(
    data.values(),
    vert=True,
    notch=True,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
    whiskerprops=whiskerprops,
)

colors = ["#b3cde3", "#ccebc5", "#decbe4", "#fed9a6"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Set the x-axis labels with data keys
ax.set_xticklabels(data.keys(), ha="center")

# Set the x-axis and y-axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Disable x-axis grid and enable y-axis grid for clarity
ax.xaxis.grid(False)
ax.yaxis.grid(True)

# Set the title of the plot
ax.set_title(title)

# Annotating medians inside the boxplots
for i, line in enumerate(bp["medians"]):
    x, y = line.get_xydata()[1]  # Top of the median line
    # Display the median value at the top of the median line
    ax.annotate(
        f"{y:.1f}", (x, y), textcoords="offset points", xytext=(0, 5), ha="center"
    )

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_92.pdf", bbox_inches="tight")
