
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the boxplots in sports
data = {
    "Points Scored": np.random.uniform(10, 40, 20),
    "Assists": np.random.uniform(0, 15, 20),
    "Rebounds": np.random.uniform(0, 20, 20),
    "Steals": np.random.uniform(0, 5, 20),
}
ylabel = "Player Statistics"
title = "Game-Day Player Performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(10, 6))

# Create the boxplots with specific colors
boxprops = dict(linestyle="-", linewidth=2, color="darkgreen")
flierprops = dict(marker="o", color="orange", markerfacecolor="orange", markersize=5)
medianprops = dict(linestyle="-", linewidth=2, color="blue")

# Boxplot with vertical orientation
bp = ax.boxplot(
    data.values(),
    vert=True,
    notch=True,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

# New color scheme representing environmental elements
colors = ["#ffcc00", "#66cc66", "#999999", "#3399ff"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Set the x-axis labels with data keys
ax.set_xticklabels(data.keys(), ha="center", rotation=15)

# Set the y-axis label
ax.set_ylabel(ylabel)

# Disable x-axis grid and enable y-axis grid for clarity
ax.xaxis.grid(False)
ax.yaxis.grid(True)

# Set the title of the plot
ax.set_title(title)

# Annotating medians inside the boxplots
for i, line in enumerate(bp["medians"]):
    x, y = line.get_xydata()[1]  # Top of the median line
    # Display the median value at the top of the median line
    ax.annotate(
        f"{y:.1f}", (x - 0.1, y), textcoords="offset points", xytext=(0, 5), ha="center"
    )

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_94.pdf", bbox_inches="tight")
