# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Create a grid of x and y values (representing coordinates)
x = np.linspace(0, 100, 200)
y = np.linspace(0, 100, 200)
X, Y = np.meshgrid(x, y)


# Define a function for elevation distribution
def elevation_distribution(X, Y):
    return (
        1000
        + 300 * np.sin(X / 10) * np.cos(Y / 20)
        + 150 * np.exp(-((X - 50) ** 2 + (Y - 50) ** 2) / 100)
    )


# Calculate elevation values on the grid
Elevation = elevation_distribution(X, Y)
xlabel = "Ancient Longitude"
ylabel = "Ancient Latitude"
title = "Elevation Map of an Ancient Civilization"
ylabel = "Elevation (m)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Use a colormap suitable for elevation (e.g., 'coolwarm')
n_colors = 15
elevation_cmap = plt.cm.get_cmap("coolwarm", n_colors)

contour = plt.contourf(X, Y, Elevation, levels=n_colors, cmap=elevation_cmap)

# Add a color bar with custom ticks
cbar = plt.colorbar(
    contour, ticks=np.linspace(Elevation.min(), Elevation.max(), n_colors)
)
cbar.ax.set_ylabel(ylabel)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Save the plot
plt.savefig("contour_24.pdf", bbox_inches="tight")
