# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting seed for reproducibility
np.random.seed(42)

# Create a grid for Liberalism and Conservatism
liberalism = np.linspace(-3, 3, 100)
conservatism = np.linspace(-3, 3, 100)
Liberalism, Conservatism = np.meshgrid(liberalism, conservatism)


# Gaussian function to simulate political data distributions
def political_distribution(Liberalism, Conservatism):
    return (
        np.exp(-((Liberalism - 0.5) ** 2 + (Conservatism - 0.5) ** 2) / 0.5)
        + np.exp(-((Liberalism + 1.5) ** 2 + (Conservatism - 1.0) ** 2) / 0.3)
        + np.exp(-((Liberalism - 1.0) ** 2 + (Conservatism + 1.5) ** 2) / 0.7)
    )


# Calculate distribution values
values = political_distribution(Liberalism, Conservatism)
xlabel = "Liberalism"
ylabel = "Conservatism"
title = "Political Traits Interaction"
cbar_label = "Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Custom discrete colormap
n_colors = 8
discrete_cmap = plt.cm.get_cmap("Pastel1", n_colors)

# Plotting the contour
contour = plt.contourf(
    Liberalism, Conservatism, values, levels=n_colors, cmap=discrete_cmap
)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(values.min(), values.max(), n_colors))
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Enhance layout and save/ display
plt.grid(True, linestyle="--", color="grey", alpha=0.7)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("contour_25.pdf", bbox_inches="tight")
