

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new sample data for population density
x = np.linspace(0, 100, 100)
y = np.linspace(0, 100, 100)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 40) ** 2 + (Y - 60) ** 2) / 200)  # High density area
Z2 = np.exp(-((X - 70) ** 2 + (Y - 30) ** 2) / 300)  # Low density area

labels = ["High Density Area", "Low Density Area"]
xlabel = "Longitude"
ylabel = "Latitude"
title = "Population Density Contours"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 10))

# Contour lines for High Density Area (green) and Low Density Area (brown)
CS1 = ax.contour(X, Y, Z1, colors="green", linewidths=1.5, label=labels[0])
CS2 = ax.contour(X, Y, Z2, colors="brown", linewidths=2.0, linestyles='dashed', label=labels[1])

# Labels for x and y axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding the title
plt.title(title)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels)

# Set the aspect of the plot and enhance visualization
ax.set_aspect("auto")
ax.grid(True, linestyle='--', alpha=0.6)
ax.set_facecolor("#f0f0f0")
ax.set_ylim(0, 100)
ax.set_xlim(0, 100)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_27.pdf", bbox_inches="tight")

