
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data to create contour lines for tourism studies
x = np.linspace(0, 24, 100)  # Time of the day in hours
y = np.linspace(1, 100, 100) # Location indices
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 9) ** 2 + (Y - 50) ** 2) / 200)  # Distribution centered around 9 AM at location index 50
Z2 = np.exp(-((X - 18) ** 2 + (Y - 75) ** 2) / 200)  # Distribution centered around 6 PM at location index 75
labels = ["Morning Peak", "Evening Peak"]
xlabel = "Time of Day (hours)"
ylabel = "Location Index"
title = "Tourism Density Heatmap"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 8))

# Contour lines for Morning Peak (dark orange) and Evening Peak (dark blue)
CS1 = ax.contour(X, Y, Z1, colors="darkorange", linestyles='dashed', linewidths=1.5, label=labels[0])
CS2 = ax.contour(X, Y, Z2, colors="darkblue", linestyles='solid', linewidths=1.5, label=labels[1])

# Labels for x and y axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, loc='upper right')

# Set the aspect of the plot to be equal
ax.set_aspect('auto')
ax.grid()
ax.set_facecolor("#f4f4f4")
ax.set_ylim(1, 100)
ax.set_xlim(0, 24)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_28.pdf", bbox_inches="tight")
