

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
x = np.linspace(-10, 10, 100)
y = np.linspace(-10, 10, 100)
X, Y = np.meshgrid(x, y)
Z = np.sin(np.sqrt(X**2 + Y**2)) * 50 + 50  # Simulating a voter sentiment scale from 0 to 100

# Text Labels and Plot Elements
xlabel = 'Region X'
ylabel = 'Region Y'
title = 'Voter Sentiment Distribution'
cbar_label = 'Sentiment (%)'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Contour
fig, ax = plt.subplots(figsize=(8, 6))
cnt = ax.contour(X, Y, Z, cmap="coolwarm", linewidths=1.5)
ax.clabel(cnt, cnt.levels, inline=True, fontsize=10)
cbar = fig.colorbar(cnt)
cbar.set_label(cbar_label)

# Set axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Additional styling
ax.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_30.pdf", bbox_inches="tight")

