
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
latitude = np.linspace(-90, 90, 100)
longitude = np.linspace(-180, 180, 100)
latitude, longitude = np.meshgrid(latitude, longitude)
temperature = np.sin(latitude / 30) * np.cos(longitude / 60) * 20

# Text label parameters
xlabel = "Latitude (°)"
ylabel = "Longitude (°)"
title = "Temperature Contour Plot"
suptitle = "Geographic Temperature Variation"
legendlabels = "Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Filled contour with labels
fig, ax = plt.subplots(figsize=(8, 6))
cnt = ax.contour(latitude, longitude, temperature, colors="k", linewidths=0.75, linestyles='solid')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=8)
cf = ax.contourf(latitude, longitude, temperature, cmap="viridis")  # A gradient colormap of blue to green

# Adding color bar to indicate intensity levels
cbar = fig.colorbar(cf, ax=ax)
cbar.set_label(legendlabels)

# Additional settings
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(suptitle, fontsize=12)
ax.grid(True, linestyle='--', alpha=0.6)  # Adding grid with dashed lines

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("contour_33.pdf", bbox_inches="tight")
