

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Labels and Titles
xlabel = "Philosophical Dimension 1"
ylabel = "Philosophical Dimension 2"
title = "Philosophical Influence Distribution"
colorbar_label = "Influence Intensity"
suptitle = "Contour Map of Philosophical Schools of Thought"
output_filename = "contour_35_0.pdf"

# Data
np.random.seed(0)
x = np.linspace(-10, 10, 100)
y = np.linspace(-10, 10, 100)
X, Y = np.meshgrid(x, y)

# Simulating philosophical influence with Gaussian functions
Z = (80 * np.exp(-((X + 3) ** 2 + (Y + 5) ** 2) / 6) +
     60 * np.exp(-((X - 6) ** 2 + (Y - 1) ** 2) / 5) +
     40 * np.exp(-((X - 2) ** 2 + (Y + 4) ** 2) / 4))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# Filled contour with labels
cnt = ax.contour(X, Y, Z, colors="black", linestyles='dashed', linewidths=1)
ax.clabel(cnt, cnt.levels, inline=True, fontsize=10)
cf = ax.contourf(X, Y, Z, cmap="viridis")

# Enhance readability
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, fontsize=14)
plt.suptitle(suptitle, fontsize=16)
cbar = fig.colorbar(cf)
cbar.set_label(colorbar_label)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("contour_35.pdf", bbox_inches="tight")
