
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate synthetic data for contour plots
x = np.linspace(-10, 10, 400)
y = np.linspace(-10, 10, 400)
X, Y = np.meshgrid(x, y)

# Define data surfaces for two product lines
Z1 = np.exp(-0.1 * (X**2 + Y**2))  # Gaussian bump for Product Line A
Z2 = np.exp(-0.1 * ((X - 5) ** 2 + (Y + 5) ** 2))  # Gaussian bump for Product Line B

# Plot configuration variables
title = "Contour Plot of Sales Growth and Profitability"
labels = ["Product Line A", "Product Line B"]
xlabel = "Sales Growth (%)"
ylabel = "Profitability (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
contour_color_1 = "#1f77b4"
contour_color_2 = "#ff7f0e"
plt.figure(figsize=(10, 6))
contour1 = plt.contour(X, Y, Z1, colors=contour_color_1, linestyles="-", linewidths=2)  # Blue for Product Line A
contour2 = plt.contour(X, Y, Z2, colors=contour_color_2, linestyles="--", linewidths=2)  # Red for Product Line B
plt.contourf(X, Y, Z1, alpha=0.3, cmap="Blues")
plt.contourf(X, Y, Z2, alpha=0.3, cmap="Reds")
plt.title(title)

# Adding labels and legend
legend_patches = [
    Patch(color=contour_color_1, label=labels[0], alpha=0.3),
    Patch(color=contour_color_2, label=labels[1], alpha=0.3),
]
plt.legend(handles=legend_patches, loc="upper right")

# Customizing the plot appearance
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.grid(True, linestyle="--", alpha=0.6)
plt.axhline(0, color="black", linewidth=0.5)
plt.axvline(0, color="black", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_36.pdf", bbox_inches="tight")
