
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate synthetic data for contour plots
longitude = np.linspace(-10, 10, 400)
latitude = np.linspace(-10, 10, 400)
LONG, LAT = np.meshgrid(longitude, latitude)

# Define two data surfaces for two destinations' influence
Influence1 = np.exp(-((LONG-2)**2 + (LAT-2)**2)/10)  # Tourist influence of Destination A
Influence2 = np.exp(-((LONG+3)**2 + (LAT+3)**2)/10)  # Tourist influence of Destination B

# Plot configuration variables
title = "Tourist Influence Contour Plot"
labels = ["Destination A", "Destination B"]
xlabel = "Longitude"
ylabel = "Latitude"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))
contour1 = plt.contour(LONG, LAT, Influence1, colors="#1f77b4", linestyles="-", linewidths=2)
contour2 = plt.contour(LONG, LAT, Influence2, colors="#ff7f0e", linestyles="--", linewidths=2)
plt.contourf(LONG, LAT, Influence1, alpha=0.3, cmap="Blues")
plt.contourf(LONG, LAT, Influence2, alpha=0.3, cmap="Oranges")
plt.title(title)

# Adding labels and legend
legend_patches = [
    Patch(color="#1f77b4", label=labels[0], alpha=0.3),
    Patch(color="#ff7f0e", label=labels[1], alpha=0.3),
]
plt.legend(handles=legend_patches)

# Customizing the plot appearance
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.grid(True, linestyle="-.", alpha=0.6)
plt.axhline(0, color="black", linewidth=0.5)
plt.axvline(0, color="black", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_38.pdf", bbox_inches="tight")
