

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulated data generation for age and religious affiliation levels
age = np.linspace(0, 100, 400)
population_percentage = np.linspace(0, 100, 400)
AGE, POPULATION_PERCENTAGE = np.meshgrid(age, population_percentage)
pos = np.dstack((AGE, POPULATION_PERCENTAGE))

# Simulate Gaussian distributions for different religious affiliations
def gaussian(x, y, mean, cov):
    return np.exp(
        -((x - mean[0]) ** 2 / (2 * cov[0][0]) + (y - mean[1]) ** 2 / (2 * cov[1][1]))
    )

Z_religion_1 = gaussian(AGE, POPULATION_PERCENTAGE, [30, 40], [[200, 0], [0, 100]])
Z_religion_2 = gaussian(AGE, POPULATION_PERCENTAGE, [60, 70], [[150, 0], [0, 80]])

# Extracted variables
title = "Distribution of Religious Affiliations by Age"
labels = ["Religion A", "Religion B"]
xlabel = "Age (Years)"
ylabel = "Percentage of Population (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))

# Contour plots for the distributions
contour_religion_1 = plt.contourf(AGE, POPULATION_PERCENTAGE, Z_religion_1, cmap="Greens", alpha=0.6)
contour_religion_2 = plt.contourf(AGE, POPULATION_PERCENTAGE, Z_religion_2, cmap="Purples", alpha=0.6)
plt.title(title)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=labels[0]),
    Patch(color="purple", label=labels[1]),
]
plt.legend(handles=legend_patches, loc='upper right')

# Axis labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjust plot to be visually appealing
plt.gca().set_aspect("equal", adjustable="box")

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_39.pdf", bbox_inches="tight")

