

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data generation for temperature and humidity levels
temperature = np.linspace(-10, 40, 400)
humidity = np.linspace(0, 100, 400)
TEMP, HUMID = np.meshgrid(temperature, humidity)
pos = np.dstack((TEMP, HUMID))

# Simulate Gaussian distributions for temperature and humidity
def gaussian(x, y, mean, cov):
    return np.exp(
        -((x - mean[0]) ** 2 / (2 * cov[0][0]) + (y - mean[1]) ** 2 / (2 * cov[1][1]))
    )

Z_temperature = gaussian(TEMP, HUMID, [15, 50], [[200, 0], [0, 200]])
Z_humidity = gaussian(TEMP, HUMID, [25, 70], [[150, 0], [0, 150]])

# Extracted variables
title = "Distribution of Temperature and Humidity Levels"
labels = ["Temperature", "Humidity"]
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))

# Contour plots for the distributions
contour_temperature = plt.contourf(TEMP, HUMID, Z_temperature, cmap="Purples", alpha=0.6)
contour_humidity = plt.contourf(TEMP, HUMID, Z_humidity, cmap="Greens", alpha=0.6)
plt.title(title)

# Create legend with color patches
legend_patches = [
    Patch(color="purple", label=labels[0]),
    Patch(color="green", label=labels[1]),
]
plt.legend(handles=legend_patches)

# Axis labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjust plot to be visually appealing
plt.gca().set_aspect("equal", adjustable="box")

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_41.pdf", bbox_inches="tight")

