
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data generation for Player Performance
x = np.linspace(0, 100, 500)
y = np.linspace(0, 100, 500)
X, Y = np.meshgrid(x, y)

# Define Gaussian Functions for data representation
def gaussian(x, y, x0, y0, sx, sy):
    return np.exp(-(((x - x0) ** 2) / (2 * sx**2) + ((y - y0) ** 2) / (2 * sy**2)))

# Generate data
P1 = gaussian(X, Y, 25, 75, 20, 30) * 30  # High performance zone
P2 = gaussian(X, Y, 70, 30, 25, 15) * 15  # Low performance zone
P3 = gaussian(X, Y, 50, 50, 30, 30) * 20  # Moderate performance zone

# Chart titles and labels
title = "Player Performance Distribution"
xlabel = "Speed"
ylabel = "Stamina"
labels = ["High Performance Zone", "Low Performance Zone", "Moderate Performance Zone"]

legend_fontsize = 12
title_fontsize = 16
label_fontsize = 14

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(12, 8))
contour1 = plt.contourf(X, Y, P1, cmap="YlOrRd", alpha=0.6)
contour2 = plt.contourf(X, Y, P2, cmap="Blues", alpha=0.4)
contour3 = plt.contourf(X, Y, P3, cmap="Greens", alpha=0.3)

# Title and labels
plt.title(title, fontsize=title_fontsize)
plt.xlabel(xlabel, fontsize=label_fontsize)
plt.ylabel(ylabel, fontsize=label_fontsize)

# Create legend with color patches
legend_patches = [
    Patch(color="orange", label=labels[0]),
    Patch(color="blue", label=labels[1]),
    Patch(color="green", label=labels[2]),
]
plt.legend(handles=legend_patches, fontsize=legend_fontsize)

# Additional plot adjustments
plt.gca().set_aspect("equal", adjustable="box")
plt.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_47.pdf", bbox_inches="tight")
