
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of latitude and longitude values
latitude = np.linspace(-90, 90, 300)
longitude = np.linspace(-180, 180, 300)
Latitude, Longitude = np.meshgrid(latitude, longitude)

# Adjust the function to reflect a complex geographical elevation distribution
def elevation_distribution_function(Latitude, Longitude):
    return (
        np.exp(-((Latitude - 30) ** 2 + (Longitude - 30) ** 2) / 400) * 2000
        + np.exp(-((Latitude + 20) ** 2 + (Longitude - 40) ** 2) / 500) * 1500
        - np.exp(-((Latitude - 25) ** 2 + (Longitude + 30) ** 2) / 1000) * 1000
        + np.exp(-((Latitude + 40) ** 2 + (Longitude + 10) ** 2) / 300) * 2500
    )

# Calculate the function values on the grid
Z = elevation_distribution_function(Latitude, Longitude)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Geographical Elevation Distribution"
colorbar_label = "Elevation (meters)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(12, 10))

# Using a colormap that suits elevation visualization
n_colors = 20  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("inferno", n_colors)

contour = plt.contourf(Latitude, Longitude, Z, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(Z.min(), Z.max(), n_colors))
cbar.set_label(colorbar_label, fontsize=14)

# Label the axes
plt.xlabel(xlabel, fontsize=16)
plt.ylabel(ylabel, fontsize=16)
plt.title(title, fontsize=18)

# Style adjustments
plt.grid(True, linestyle="--", alpha=0.7)  # Add a grid for better readability
plt.xticks(fontsize=14)
plt.yticks(fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_48.pdf", bbox_inches="tight")
