
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of x and y values representing days and price levels for two stocks
days = np.linspace(0, 100, 200)
price_levels = np.linspace(0, 500, 200)
X, Y = np.meshgrid(days, price_levels)

# Define a function to simulate stock price distributions
def stock_price_distribution_function(X, Y):
    # Simulate stock prices for two companies
    stock1_prices = np.exp(-((X - 50) ** 2 + (Y - 300) ** 2) / 2000) * 100  # Centered around (50, 300)
    stock2_prices = np.exp(-((X - 70) ** 2 + (Y - 200) ** 2) / 3000) * 100  # Centered around (70, 200)
    return stock1_prices + stock2_prices

# Calculate the function values on the grid
Z = stock_price_distribution_function(X, Y)
xlabel = "Days"
ylabel = "Price Level"
title = "Simulated Stock Price Fluctuations over Time"
colorbar_label = "Price Level Indicator"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Use a colormap that suits financial data visualization
n_colors = 10  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("viridis", n_colors)  # Changed to viridis for better visualization

contour = plt.contourf(X, Y, Z, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(Z.min(), Z.max(), n_colors))
cbar.set_label(colorbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# Style adjustments
plt.grid(True, linestyle="--", alpha=0.7)  # Add a grid for better readability
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_50.pdf", bbox_inches="tight")

# Show the final render to check visually
