
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a grid of x (contemplation time) and z (wisdom level) values
np.random.seed(51)  # Different seed for different data
x = np.linspace(0, 100, 120)  # Contemplation Time in hours
z = np.linspace(0, 100, 120)  # Wisdom Level
X, Z = np.meshgrid(x, z)

# Define the philosophical insights landscape function with different peaks
def philosophical_insights_landscape(X, Z):
    return (
        np.exp(-((X - 30) ** 2 + (Z - 40) ** 2) / 200)
        + np.exp(-((X - 70) ** 2 + (Z - 70) ** 2) / 300)
        + np.exp(-((X - 50) ** 2 + (Z - 20) ** 2) / 150)
    )

# Calculate the function values on the grid
Z_values = philosophical_insights_landscape(X, Z)
xlabel = "Contemplation Time (hours)"
ylabel = "Wisdom Level"
title = "Philosophical Insights Landscape: Contemplation Time vs. Wisdom Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a different colormap with "RdYlBu"
n_colors = 12  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("RdYlBu", n_colors)

contour = plt.contourf(X, Z, Z_values, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(
    contour, ticks=np.linspace(Z_values.min(), Z_values.max(), n_colors)
)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_51.pdf", bbox_inches="tight")
