

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a grid of x (longitude) and z (latitude) values
np.random.seed(42)  # Different seed for different data
x = np.linspace(-100, 100, 150)
z = np.linspace(-50, 50, 150)
X, Z = np.meshgrid(x, z)

# Define the landscape function with different peaks for climate data
def landscape_function(X, Z):
    return (
        20 * np.exp(-((X + 20) ** 2 + (Z - 10) ** 2) / 200)
        + 15 * np.exp(-((X - 60) ** 2 + (Z + 30) ** 2) / 150)
        + 10 * np.exp(-((X + 50) ** 2 + (Z - 20) ** 2) / 100)
        + 5 * np.exp(-((X - 30) ** 2 + (Z + 40) ** 2) / 50)
    )

# Calculate the function values on the grid
Z_values = landscape_function(X, Z)
xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Climate Temperature Variation Landscape"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(12, 10))

# Using a colormap suitable for temperature data
n_colors = 15  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("viridis", n_colors)

# Create contour plot
contour = plt.contourf(X, Z, Z_values, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(
    contour, ticks=np.linspace(Z_values.min(), Z_values.max(), n_colors)
)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add grid lines for better readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_53.pdf", bbox_inches="tight")

