
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a new set of grid for different variables
x = np.linspace(0, 30, 100)  # Days in a month
y = np.linspace(0, 100, 100)  # Engagement rate range
X, Y = np.meshgrid(x, y)

# Define a function to simulate engagement patterns over time
def engagement_pattern(X, Y):
    return 0.4 * np.sin(2 * np.pi * X / 30) + 0.3 * np.cos(2 * np.pi * Y / 100) + 0.2 * np.sin(np.pi * X / 30) * np.cos(np.pi * Y / 100)

# Calculate values on the grid
Z_values = engagement_pattern(X, Y)
xlabel = "Days"
ylabel = "Engagement Rate (%)"
title = "Simulated Viewer Engagement Over Time"
cbar_label = "Engagement Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a distinct colormap with a finance theme (greens, and blues)
n_levels = 20  # Number of contour levels
cmap = plt.cm.viridis

contour = plt.contourf(X, Y, Z_values, levels=n_levels, cmap=cmap)
plt.contour(X, Y, Z_values, levels=n_levels, colors="k", linewidths=0.5)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_54.pdf", bbox_inches="tight")
