

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a new set of grid for different variables
supply = np.linspace(0, 500, 100)
demand = np.linspace(0, 500, 100)
Supply, Demand = np.meshgrid(supply, demand)

# Define a new function with unique pattern
def economic_interaction(Supply, Demand):
    return np.sin(Supply/50) * np.cos(Demand/50) - 0.3 * np.sin(2 * Supply/50) * np.cos(2 * Demand/50)

# Calculate values on the grid
Z_values = economic_interaction(Supply, Demand)
xlabel = "Supply (in Units)"
ylabel = "Demand (in Units)"
title = "Economic Interaction Between Supply and Demand"
cbar_label = "Surplus/Shortage Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a distinct colormap with "viridis"
n_levels = 20  # Number of contour levels
cmap = plt.cm.viridis

contour = plt.contourf(Supply, Demand, Z_values, levels=n_levels, cmap=cmap)
plt.contour(Supply, Demand, Z_values, levels=n_levels, colors="k", linewidths=0.5, linestyles='dashed')

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_55.pdf", bbox_inches="tight")

