
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of x and y values representing different regions of a city
x = np.linspace(0, 50, 100)
y = np.linspace(0, 50, 100)
X, Y = np.meshgrid(x, y)

# Function representing the social media activity distribution influenced by population density and event locations
def social_media_activity_distribution(X, Y):
    return np.exp(-((X - 25)**2 + (Y - 25)**2) / 100) + np.exp(-((X - 15)**2 + (Y - 15)**2) / 50)

# Calculate the function values on the grid
Z_values = social_media_activity_distribution(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Social Media Activity Distribution"
cbar_label = "Activity Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a colormap suitable for social media activity data
cmap = plt.cm.get_cmap("YlGnBu")

contour = plt.contourf(X, Y, Z_values, levels=20, cmap=cmap)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')
plt.title(title, fontsize=14, fontweight='bold')

# Enhance grid lines for better readability
plt.grid(True, linestyle="--", alpha=0.5, color='grey')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_57.pdf", bbox_inches="tight")
