
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# Geographical grid representing an area
x = np.linspace(0, 100, 100)  # hypothetical units along one axis
y = np.linspace(0, 100, 100)  # hypothetical units along another axis
X, Y = np.meshgrid(x, y)

# Intensity levels of two different spiritual practices
Z1 = 50 + 30 * np.exp(
    -((X - 30) ** 2 + (Y - 70) ** 2) / 800
)  # Meditation Intensity
Z2 = 70 + 20 * np.exp(-((X - 70) ** 2 + (Y - 30) ** 2) / 800)  # Prayer Intensity

# Text labels
labels = ["Meditation Intensity", "Prayer Intensity"]
xlabel = "Hypothetical Unit (X)"
ylabel = "Hypothetical Unit (Y)"
title = "Intensity of Spiritual Practices in a Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(12, 8))

# Contour lines for Meditation Intensity (green) and Prayer Intensity (brown)
CS1 = ax.contour(
    X, Y, Z1, colors="#228B22", linestyles="solid", linewidths=2, label=labels[0]
)
CS2 = ax.contour(
    X, Y, Z2, colors="#8B4513", linestyles="dashed", linewidths=2, label=labels[1]
)

# Labels for x and y axes and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels)

# Set the aspect of the plot for readability
ax.set_aspect("auto")
ax.grid(True, linestyle='--', color='gray', alpha=0.7)
ax.set_facecolor("#f0f0f0")
ax.set_ylim(0, 100)
ax.set_xlim(0, 100)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_60.pdf", bbox_inches="tight")
