
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# Hypothetical technology adoption data over different years and regions
years = np.linspace(2000, 2020, 100)  # years
regions = np.linspace(1, 5, 100)  # regions
Years, Regions = np.meshgrid(years, regions)
Adoption1 = 20 + 50 * np.exp(-((Years - 2005) ** 2 + (Regions - 3) ** 2) / 20)  # Technology A adoption
Adoption2 = 10 + 70 * np.exp(-((Years - 2015) ** 2 + (Regions - 4) ** 2) / 25)  # Technology B adoption
labels = ["Technology A", "Technology B"]
xlabel = "Years"
ylabel = "Regions"
title = "Technology Adoption Rates Over Time and Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

# Contour lines for Technology A (green) and Technology B (orange)
color1 = "green"
color2 = "darkorange"
CS1 = ax.contour(
    Years, Regions, Adoption1, colors=color1, linestyles="solid", linewidths=1.5, label=labels[0]
)
CS2 = ax.contour(
    Years, Regions, Adoption2, colors=color2, linestyles="dashed", linewidths=1.5, label=labels[1]
)

# Labels for x and y axes and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels)

# Set the aspect of the plot for better readability
ax.set_aspect("auto")
ax.grid(True, linestyle='--', linewidth=0.5)
ax.set_facecolor("#f3f3f3")
ax.set_ylim(1, 5)
ax.set_xlim(2000, 2020)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_61.pdf", bbox_inches="tight")
