
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Population Density data over a year
x = np.linspace(0, 365, 100)  # days of the year
y = np.linspace(0, 500, 100)  # population density (people per sq. km)
X, Y = np.meshgrid(x, y)
Z1 = 200 + 100 * np.exp(-((X - 150) ** 2 + (Y - 250) ** 2) / 5000)  # Urban
Z2 = 50 + 30 * np.exp(-((X - 250) ** 2 + (Y - 150) ** 2) / 7000)   # Rural
labels = ["Urban", "Rural"]
xlabel = "Days of the Year"
ylabel = "Population Density (people/km²)"
title = "Urban and Rural Population Density Trends Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

# Contour lines for Urban (green) and Rural (purple)
CS1 = ax.contour(
    X, Y, Z1, colors="green", linestyles="solid", linewidths=1.5, label=labels[0]
)
CS2 = ax.contour(
    X, Y, Z2, colors="purple", linestyles="dashed", linewidths=1.5, label=labels[1]
)

# Labels for x and y axes and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, loc='upper right')

# Set the aspect of the plot for better readability
ax.set_aspect("auto")
ax.grid(True, linestyle='--', alpha=0.7)
ax.set_facecolor("#f7f7f7")
ax.set_ylim(0, 500)
ax.set_xlim(0, 365)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_62.pdf", bbox_inches="tight")
