
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate data for simulated terrain elevation
x = np.linspace(-5, 5, 200)
y = np.linspace(-5, 5, 200)
X, Y = np.meshgrid(x, y)
Z_sin = np.sin(np.sqrt(X**2 + Y**2)) * np.exp(-0.1*np.sqrt(X**2 + Y**2))
Z_cos = np.cos(np.sqrt(X**2 + Y**2)) * np.exp(-0.1*np.sqrt(X**2 + Y**2))
labels = ["Sine Contours", "Cosine Contours"]
xlabel = "X-axis (km)"
ylabel = "Y-axis (km)"
title = "Simulated Terrain Elevation"
cbar_label = "Elevation (meters)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

# Contour lines for Sine (blue shades) and Cosine (orange shades)
CS_sin = ax.contour(X, Y, Z_sin, colors="blue", linestyles="solid", linewidths=1.5)
CS_cos = ax.contour(X, Y, Z_cos, colors="orange", linestyles="dashed", linewidths=1.5)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=15)
ax.set_ylabel(ylabel, fontsize=15)
ax.set_title(title, fontsize=18)

# Adding a legend manually
h1, _ = CS_sin.legend_elements()
h2, _ = CS_cos.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=13)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True, linestyle=':', color='gray')
ax.set_facecolor("#e0f7fa")
ax.set_ylim(-5, 5)
ax.set_xlim(-5, 5)

# Add color bar to represent elevation
field_intensity = ax.contourf(X, Y, Z_sin + Z_cos, alpha=0.3, cmap="inferno")
cbar = fig.colorbar(field_intensity, ax=ax)
cbar.set_label(cbar_label, fontsize=13)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_63.pdf", bbox_inches="tight")
