

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data to create another type of distribution contour lines
x = np.linspace(-15, 15, 150)
y = np.linspace(-15, 15, 150)
X, Y = np.meshgrid(x, y)
Z1 = np.sin(0.1 * np.sqrt(X**2 + Y**2)) / (0.1 * np.sqrt(X**2 + Y**2))  # Temperature variations
Z2 = np.cos(0.1 * np.sqrt(X**2 + Y**2)) / (0.1 * np.sqrt(X**2 + Y**2))  # Humidity variations
labels = ["Temperature Variations", "Humidity Variations"]
xlabel = "Longitude"
ylabel = "Latitude"
title = "Temperature and Humidity Variations"
cbar_label = "Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors used for the different contour lines
color_temperature = "blue"
color_humidity = "orange"

# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

# Contour lines for Temperature Variations (cool colors) and Humidity Variations (warm colors)
CS1 = ax.contour(X, Y, Z1, colors=color_temperature, linestyles="solid", linewidths=2)
CS2 = ax.contour(X, Y, Z2, colors=color_humidity, linestyles="dashed", linewidths=2)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=15)
ax.set_ylabel(ylabel, fontsize=15)
ax.set_title(title, fontsize=18)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=13)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True, linestyle='--', color='grey', alpha=0.5)
ax.set_facecolor("#f5f5f5")
ax.set_ylim(-15, 15)
ax.set_xlim(-15, 15)

# Add color bar to represent field intensity
field_intensity = ax.contourf(X, Y, Z1 + Z2, alpha=0.3, cmap="coolwarm")
cbar = fig.colorbar(field_intensity, ax=ax)
cbar.set_label(cbar_label, fontsize=13)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_65.pdf", bbox_inches="tight")
