

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data to create ocean temperature zone contour lines
longitude = np.linspace(-50, 50, 200)
latitude = np.linspace(-50, 50, 200)
Longitude, Latitude = np.meshgrid(longitude, latitude)
Cold_Zone = np.exp(-((Longitude - 20) ** 2 + (Latitude - 20) ** 2) / 200)
Warm_Zone = np.exp(-((Longitude + 20) ** 2 + (Latitude + 10) ** 2) / 200)

# Labels and texts
labels = ["Cold Ocean Zone", "Warm Ocean Zone"]
xlabel = "Longitude"
ylabel = "Latitude"
title = "Ocean Temperature Zones"
colorbar_label = "Temperature Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_fontsize = 13
xlabel_fontsize = 15
ylabel_fontsize = 15
title_fontsize = 18
colorbar_fontsize = 14

# Create the plot
fig, ax = plt.subplots(figsize=(14, 10))  # Adjusted figure size for better visual impact

# Contour lines for Cold Zone (cool blues) and Warm Zone (warm reds)
CS1 = ax.contour(Longitude, Latitude, Cold_Zone, colors="blue", linestyles="dotted", linewidths=2.5)
CS2 = ax.contour(Longitude, Latitude, Warm_Zone, colors="orange", linestyles="dashdot", linewidths=3)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel, fontsize=ylabel_fontsize)
ax.set_title(title, fontsize=title_fontsize)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=legend_fontsize)

# Set the aspect of the plot to be equal
ax.set_aspect("equal")
ax.grid(True, linestyle='--', color='grey', alpha=0.6)
ax.set_facecolor("#f0f0f0")
ax.set_xlim(-50, 50)
ax.set_ylim(-50, 50)

# Add color bar to represent temperature intensity
temperature = ax.contourf(Longitude, Latitude, Cold_Zone + Warm_Zone, alpha=0.4, cmap="coolwarm")
cbar = fig.colorbar(temperature, ax=ax)
cbar.set_label(colorbar_label, fontsize=colorbar_fontsize)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_66.pdf", bbox_inches="tight")

