
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data: Simulate student performance across different subjects
np.random.seed(20)
X, Y = np.meshgrid(np.linspace(-5, 5, 400), np.linspace(-5, 5, 400))

# Gaussian functions representing different subjects' performance
Z1 = np.exp(-(((X - 1) ** 2) / 2 + ((Y - 1) ** 2) / 3))  # Subject A
Z2 = np.exp(-(((X + 1) ** 2) / 3 + ((Y + 1) ** 2) / 4))  # Subject B
Z3 = np.exp(-(((X - 2) ** 2) / 4 + ((Y + 2) ** 2) / 2))  # Subject C
Z4 = np.exp(-(((X + 2) ** 2) / 5 + ((Y - 2) ** 2) / 6))  # Subject D
Z = Z1 + Z2 + Z3 + Z4

# Extracted variables
title_text = "Simulated Student Performance Across Subjects"
xlabel_text = "Subject Axis"
ylabel_text = "Student Number Axis"
colorbar_label_text = "Performance Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
contour_levels = 15
linewidths = 0.75
fontsize = 10
fmt = "%.2f"
figsize = (10, 8)
# Filled contour with labels
fig, ax = plt.subplots(figsize=figsize)
cnt = ax.contour(X, Y, Z, levels=contour_levels, colors="brown", linewidths=linewidths, linestyles='dashed')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=fontsize, fmt=fmt)
contour_filled = ax.contourf(X, Y, Z, levels=contour_levels, cmap="Greens")

# Title and Labels
ax.set_title(title_text)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
cbar = fig.colorbar(contour_filled, ax=ax)
cbar.set_label(colorbar_label_text)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_76.pdf", bbox_inches="tight")
