

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data: Simulate network signal strength data using Gaussian functions
np.random.seed(10)
X, Y = np.meshgrid(np.linspace(-10, 10, 400), np.linspace(-10, 10, 400))

# Use differently parameterized Gaussian blobs representing signal strengths
Z1 = np.exp(-(((X - 3) ** 2) / 4 + ((Y - 3) ** 2) / 6)) * 5
Z2 = np.exp(-(((X + 2) ** 2) / 6 + ((Y + 2) ** 2) / 8)) * 4
Z3 = np.exp(-(((X - 4) ** 2) / 8 + ((Y + 4) ** 2) / 4)) * 6
Z4 = np.exp(-(((X + 5) ** 2) / 10 + ((Y - 5) ** 2) / 12)) * 3
Z = Z1 + Z2 + Z3 + Z4

# Extracted variables
title_text = "Network Signal Strength Distribution"
xlabel_text = "Longitude"
ylabel_text = "Latitude"
colorbar_label_text = "Signal Strength (dB)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
contour_levels = 15
linewidths = 1.0
fontsize = 12
fmt = "%.1f"
figsize = (10, 8)
# Filled contour with labels
fig, ax = plt.subplots(figsize=figsize)
cnt = ax.contour(X, Y, Z, levels=contour_levels, colors="black", linewidths=linewidths, linestyles='solid')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=fontsize, fmt=fmt)
contour_filled = ax.contourf(X, Y, Z, levels=contour_levels, cmap="viridis")

# Title and Labels
ax.set_title(title_text, fontsize=14)
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
cbar = fig.colorbar(contour_filled, ax=ax)
cbar.set_label(colorbar_label_text, fontsize=12)

# Add grid for enhanced readability
ax.grid(True, linestyle='--', alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_77.pdf", bbox_inches="tight")

