
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Sample data for climate metrics
temperature = np.random.normal(loc=25, scale=5, size=1000)
humidity = np.random.normal(loc=60, scale=10, size=1000)
co2_levels = np.random.normal(loc=400, scale=50, size=1000)
labels = ["Temperature (°C)", "Humidity (%)", "CO2 Levels (ppm)"]
reserved_label = "Safe CO2 Threshold"
xlabel = "Measurement Value"
ylabel = "Density"
chart_title = "Climate Metrics Density Distribution"
legend_labels = ["Temperature (°C)", "Humidity (%)", "CO2 Levels (ppm)", "Safe CO2 Threshold"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot the density plots
for data, color, label in zip(
    [temperature, humidity, co2_levels],
    colors,
    labels
):
    density = gaussian_kde(data)
    xs = np.linspace(0, 600, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the reserved price line
plt.axvline(x=450, color="purple", linestyle="--", label=reserved_label)

# Set labels and title
ax.set_xlim(0, 600)
ax.set_xticks(np.arange(0, 601, 100))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(chart_title)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_30.pdf", bbox_inches="tight")
