

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

from scipy.stats import gaussian_kde

# Generate new data reflecting sports trends
goals_scored = np.random.normal(loc=20, scale=5, size=1000)
assists_made = np.random.normal(loc=15, scale=3, size=1000)
matches_played = np.random.normal(loc=30, scale=4, size=1000)
labels = ["Goals Scored", "Assists Made", "Matches Played"]
xlabel = "Value"
ylabel = "Density"
avxlabel = "Performance Benchmark"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjusted to match the original image's dimensions

# Plot the density plots
for data, color, label in zip(
    [goals_scored, assists_made, matches_played],
    ["#1f77b4", "#ff7f0e", "#2ca02c"],  # Using distinct colors
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(5, 40, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the reserved price line
plt.axvline(x=25.0, color="purple", linestyle="--", label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(5, 40)
ax.set_xticks([5, 10, 15, 20, 25, 30, 35, 40])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_31.pdf", bbox_inches="tight")

